/* APPLEVU.c by bill buckels 2007         */
/* a slideshow for the apple //e          */
/* written in Manx Aztec C65 Version 3.2b */
/* runs under PRODOS 8                    */
/* displays BSaved HIRES Images           */
/* requires a text script called piclist  */

#include <console.h>
#include <stdio.h>
#include <fcntl.h>
#include <prodos.h>
#include <sgtty.h>
#include <device.h>
#include <sysfunc.h>

#define TEXTMODE  0
#define GRAFMODE  2  /* graphics only */

int getch();

main()
{
    FILE *fp;
    int idx,bsaved;
    char picname[66];

   /* initialize video */
   setcrtmode(GRAFMODE);
   if (getch() == 27)goto ENDER;

   STARTER:;

   if((fp=fopen("PICLIST","r"))==NULL)goto ENDER;
   fgets(picname,66,fp); /* get the first filename */

   bsaved=1;
   while(picname[0]>' ' && picname[0] < '{')
   {
        idx=0;  /* replace carriage return with null */
        while(picname[idx]!=0)
         {

 			if(picname[idx] == '.') {
 			   if (picname[idx+1] == 'B' && picname[idx+2] == 'O' && picname[idx+3] == 'T')
 			      bsaved = 0;
 			   else  if (picname[idx+1] == 'T' && picname[idx+2] == 'O' && picname[idx+3] == 'P')
 			      bsaved = 0;
  			   else  if (picname[idx+1] == 'R' && picname[idx+2] == 'A' && picname[idx+3] == 'G')
 			      bsaved = 0;
			}

         if(picname[idx]< ' ')picname[idx]= 0;
         else idx++;
         }
   if (bsaved == 0) piclode(picname);
   else bload(picname);

    if(getch()==27)
        {
         fclose(fp);
         goto ENDER;
        }
    fgets(picname,66,fp);
    }
    fclose(fp);
    goto STARTER;

  ENDER:;
    scr_clear();
    setcrtmode(TEXTMODE);
    _exit();
}


bload(name)
char *name;
{
   int fh;

   fh = open(name,O_RDONLY,0x04); /* open a binary file */
   read(fh,(char *)0x4000,0x2000);
   close(fh);

}

piclode(name)
char *name;
{
   int fh,y,y1=0,x1,temp,bos;
   char buffer[41];

   int height,packet;
   char tempchar[2];

   fh = open(name,O_RDONLY,0x04); /* open a binary file */

   read(fh,tempchar,2);

   packet= (int)tempchar[0];
   height= (int)tempchar[1];

   /* center the picture in the screen */

   x1 = 20-(packet/2); /* break on even byte boundaries */
   if((x1%2)!=0)x1--;

   bos=y1+height;

   for(y=y1;y<bos;y++)
   {
     gethibase(y,&temp);
     read(fh,(char *)(temp+x1),packet); /* read each raster to the screen */
     }
   close(fh);

}

